#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;
typedef long long ll;
const ll BESKONACNO = 4e18;
struct Jarbol {
    int id;
    ll x, h;};
bool uporediPoX(const Jarbol& a, const Jarbol& b) {
    return a.x < b.x;}
struct drvoMaks {
    int velicina;
    vector<ll> stablo;
    drvoMaks(int n) : velicina(n), stablo(n + 1, -BESKONACNO) {}
    void azuriraj(int indeks, ll vrednost) {
        for (; indeks <= velicina; indeks += indeks & -indeks)
            stablo[indeks] = max(stablo[indeks], vrednost);}
    ll upit(int indeks) {
        ll rezultat = -BESKONACNO;
        for (; indeks > 0; indeks -= indeks & -indeks)
            rezultat = max(rezultat, stablo[indeks]);
        return rezultat;}};
struct drvoMin {
    int velicina;
    vector<ll> stablo;
    drvoMin(int n) : velicina(n), stablo(n + 1, BESKONACNO) {}
    void azuriraj(int indeks, ll vrednost) {
        for (; indeks <= velicina; indeks += indeks & -indeks)
            stablo[indeks] = min(stablo[indeks], vrednost);}
    ll upit(int indeks) {
        ll rezultat = BESKONACNO;
        for (; indeks > 0; indeks -= indeks & -indeks)
            rezultat = min(rezultat, stablo[indeks]);
        return rezultat;}};
int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int n;
    cin >> n;
    vector<Jarbol> jarboli(n);
    for (int i = 0; i < n; i++) jarboli[i].id = i;
    for (int i = 0; i < n; i++) cin >> jarboli[i].x;
    for (int i = 0; i < n; i++) cin >> jarboli[i].h;
    sort(jarboli.begin(), jarboli.end(), uporediPoX);
    vector<ll> jedinstvene_visine;
    for (int i = 0; i < n; i++) jedinstvene_visine.push_back(jarboli[i].h);
    sort(jedinstvene_visine.begin(), jedinstvene_visine.end());
    jedinstvene_visine.erase(unique(jedinstvene_visine.begin(), jedinstvene_visine.end()), jedinstvene_visine.end());
    auto daj_rang = [&](ll h) {
        int pozicija = lower_bound(jedinstvene_visine.begin(), jedinstvene_visine.end(), h) - jedinstvene_visine.begin();
        return (int)jedinstvene_visine.size() - pozicija; };
    int maks_rang = jedinstvene_visine.size();
    vector<ll> konacni_rezultati(n, BESKONACNO);
    drvoMaks bitMaks(maks_rang);
    for (int i = 0; i < n; i++) {
        int r = daj_rang(jarboli[i].h);
        ll pronadjena_vrednost = bitMaks.upit(r);
        if (pronadjena_vrednost != -BESKONACNO) {
            ll trenutna_udaljenost = (jarboli[i].x + jarboli[i].h) - pronadjena_vrednost;
            konacni_rezultati[jarboli[i].id] = min(konacni_rezultati[jarboli[i].id], trenutna_udaljenost);}
        bitMaks.azuriraj(r, jarboli[i].x + jarboli[i].h);}
    drvoMin bitMin(maks_rang);
    for (int i = n - 1; i >= 0; i--) {
        int r = daj_rang(jarboli[i].h);
        ll pronadjena_vrednost = bitMin.upit(r);
        if (pronadjena_vrednost != BESKONACNO) {
            ll trenutna_udaljenost = pronadjena_vrednost - (jarboli[i].x - jarboli[i].h);
            konacni_rezultati[jarboli[i].id] = min(konacni_rezultati[jarboli[i].id], trenutna_udaljenost);}
        bitMin.azuriraj(r, jarboli[i].x - jarboli[i].h);}
    for (int i = 0; i < n; i++) {
        if (konacni_rezultati[i] >= BESKONACNO) {
            cout << -1 << "\n";
        } else {
            cout << konacni_rezultati[i] << "\n";}}
    return 0;
}